
#ifndef CRYS_SST_KG_C
#define CRYS_SST_KG_C

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_SST_error.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CRYS_SST_KG.c    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:42:30 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the implementation of the CRYS6 key generation functions. 
   *
   *  \version CRYS_SST_KG.c#1:incl:13
   *  \author avis
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/

/** 
@brief - a definition describing the low level Engine type ( SW , Hardware , Etc )
*/


/************************ Enums ********************************/

/* Enum defining the user's key size argument */

/************************ Typedefs  ****************************/


/************************ context Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/


/**
 * @brief The function creates AES key saves it in the SST and 
 *        return the handle to it.
 *
 *
 * @param[in] TeansactionId  the opened atransaction for the SST changes. 
 *
 * @param[in] SessionId  the opened authenticator SessionId. 
 *
 * @param[in] MasterAuthHandle - the master authenticator that has all of the 
 *								access writes on the new inserted data including 
 *								binding writes to additional authenticators.
 *
 * @param[in] DataType  user depand for internal SST use. 
 *
 * @param[in] KeySize - type of AES key (128,192 or 256 bits).
 *
 * @param[in/out] KeyHandle_ptr - handle to SST entry.The user can enter an empty handle  
 *								  and get a new handle, or enter handle and force the SST to use it
 *								  if possible.
 *
 * @return CRYSError_t - On success the value CRYS_OK is returned, 
 *                        and on failure a value from CRYS_AES_error.h or CRYS_SST_error.h
 */

CEXPORT_C CRYSError_t  CRYS_SST_KG_AES(  DxUint32_t			TeansactionId,
									     SSTSessionId_t		SessionId,
										 SSTHandle_t		MasterAuthHandle,
			                             SSTDataType_t      DataType,
										 CRYS_AES_KeySize_t KeySize,
										 SSTHandle_t		*KeyHandle_ptr,
										 DxUint8_t*			aWorkspace_ptr,
										 DxUint32_t		    aWorkspaceSizeInBytes)
{

	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_AES_OP_CODE, 9,
	   							 /* PARAMETERS: */
								 TeansactionId,
							     SessionId,
								 MasterAuthHandle,
								 DataType,
								 KeySize,
								 KeyHandle_ptr,
								 aWorkspace_ptr, aWorkspaceSizeInBytes );

}


/**
 * @brief The function creates DES key saves it in the SST and 
 *        return the handle to it.
 *
 *
 * @param[in] TeansactionId  the opened atransaction for the SST changes. 
 *
 * @param[in] SessionId  the opened authenticator SessionId. 
 *
 * @param[in] MasterAuthHandle - the master authenticator that has all of the 
 *								access writes on the new inserted data including 
 *								binding writes to additional authenticators.
 *
 * @param[in] DataType  user depand for internal SST use. 
 *
 * @param[in,out] NumOfKeys - type of DES key (DES or 3DES).
 *
 * @param[in/out] KeyHandle_ptr - handle to SST entry.The user can enter an empty handle  
 *								  and get a new handle, or enter handle and force the SST to use it
 *								  if possible.
 *
 * @return CRYSError_t - On success the value CRYS_OK is returned, 
 *                        and on failure a value from CRYS_DES_error.h or CRYS_SST_error.h
 */

CEXPORT_C CRYSError_t  CRYS_SST_KG_DES(  DxUint32_t			TeansactionId,
									     SSTSessionId_t		SessionId,
										 SSTHandle_t		MasterAuthHandle,
			                             SSTDataType_t      DataType,
										 CRYS_DES_NumOfKeys_t NumOfKeys,
										 SSTHandle_t		*KeyHandle_ptr,
										 DxUint8_t*			aWorkspace_ptr,
										 DxUint32_t			aWorkspaceSizeInBytes)
{

	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_DES_OP_CODE, 9,
	   							 /* PARAMETERS: */
								 TeansactionId,
							     SessionId,
								 MasterAuthHandle,
								 DataType,
								 NumOfKeys,
								 KeyHandle_ptr,
								 aWorkspace_ptr, aWorkspaceSizeInBytes );

}

/**
 * @brief The function creates HMAC key saves it in the SST and 
 *        return the handle to it.
 *
 *
 * @param[in] TeansactionId  the opened atransaction for the SST changes. 
 *
 * @param[in] SessionId  the opened authenticator SessionId. 
 *
 * @param[in] MasterAuthHandle - the master authenticator that has all of the 
 *								access writes on the new inserted data including 
 *								binding writes to additional authenticators.
 *
 * @param[in] DataType  user depand for internal SST use. 
 *
 *
 * @param[in,out] KeySize - HMAC key len in bytes.
 *
 * @param[in/out] KeyHandle_ptr - handle to SST entry.The user can enter an empty handle  
 *								  and get a new handle, or enter handle and force the SST to use it
 *								  if possible.
 *
 * @return CRYSError_t - On success the value CRYS_OK is returned, 
 *                        and on failure a value from CRYS_HMAC_error.h or CRYS_SST_error.h
 */

CEXPORT_C CRYSError_t  CRYS_SST_KG_HMAC( DxUint32_t			TeansactionId,
									     SSTSessionId_t		SessionId,
										 SSTHandle_t		MasterAuthHandle,
			                             SSTDataType_t      DataType,
										 DxUint32_t			KeySize,
										 SSTHandle_t		*KeyHandle_ptr,
										 DxUint8_t*			aWorkspace_ptr,
							             DxUint32_t			aWorkspaceSizeInBytes)
{

	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_HMAC_OP_CODE, 9,
	   							 /* PARAMETERS: */
								 TeansactionId,
							     SessionId,
								 MasterAuthHandle,
								 DataType,
								 KeySize,
								 KeyHandle_ptr,
								 aWorkspace_ptr, aWorkspaceSizeInBytes );

}

/**
 * @brief The function creates RSA key pair saves it in the SST and 
 *        return the handle to it.
 *
 *
 * @param[in] TeansactionId  the opened atransaction for the SST changes. 
 *
 * @param[in] SessionId  the opened authenticator SessionId. 
 *
 * @param[in] MasterAuthHandle - the master authenticator that has all of the 
 *								access writes on the new inserted data including 
 *								binding writes to additional authenticators.
 *
 * @param[in] DataType  user depand for internal SST use. 
 *
 *
 * @param[in/out] KeyHandle_ptr - handle to SST entry.The user can enter an empty handle  
 *								  and get a new handle, or enter handle and force the SST to use it
 *								  if possible.
 *
 * @param[in] PubExp_ptr - public exponent  
 *
 * @param[in] PubExpSizeInBytes - size of public exponent in bytes.  
 *
 * @param[in] KeySize - size of the modulus.  
 *
 * @param[out] UserPrivKey_ptr - private key structure.This structure is used as internal buffer.  
 *
 * @param[out] UserPubKey_ptr -public key structure.This structure is used as internal buffer.  
 *
 * @param[in] KeyGenData_ptr - internal buffer for the key gen operation.  
 *
 * @return CRYSError_t - On success the value CRYS_OK is returned, 
 *                        and on failure a value from CRYS_RSA_error.h or CRYS_SST_error.h
 */

CEXPORT_C CRYSError_t CRYS_SST_RSA_KG_GenerateKeyPair(DxUint32_t					TeansactionId,
													  SSTSessionId_t				SessionId,
													  SSTHandle_t					MasterAuthHandle,
													  SSTDataType_t					DataType,
													  SSTHandle_t					*KeyHandle_ptr,
													  DxUint8_t						*PubExp_ptr,
													  DxUint16_t					PubExpSizeInBytes,
													  DxUint32_t					KeySize,
													  CRYS_SST_RSA_keys_and_data_container_t	*KeyGenData_ptr)
{

	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_RSA_OP_CODE, 10,
	   							 /* PARAMETERS: */
								 TeansactionId,
							     SessionId,
								 MasterAuthHandle,
								 DataType,
								 KeyHandle_ptr,
								 PubExp_ptr,
								 PubExpSizeInBytes, KeySize,
								 KeyGenData_ptr);
}


/**
 * @brief The function creates RSA key pair with CRT format ,saves it in the SST and 
 *        return the handle to it.
 *
 *
 * @param[in] SessionId  the opened authenticator SessionId. 
 *
 * @param[in] MasterAuthHandle - the master authenticator that has all of the 
 *								access writes on the new inserted data including 
 *								binding writes to additional authenticators.
 *
 * @param[in/out] KeyHandle_ptr - handle to SST entry.The user can enter an empty handle  
 *								  and get a new handle, or enter handle and force the SST to use it
 *								  if possible.
 *
 * @param[in] PubExp_ptr - public exponent  
 *
 * @param[in] PubExpSizeInBytes - size of public exponent in bytes.  
 *
 * @param[in] KeySize - size of the modulus.  
 *
 * @param[out] UserPrivKey_ptr - private key structure.This structure is used as internal buffer.  
 *
 * @param[out] UserPubKey_ptr -public key structure.This structure is used as internal buffer.  
 *
 * @param[in] KeyGenData_ptr - internal buffer for the key gen operation.  
 *
 * @return CRYSError_t - On success the value CRYS_OK is returned, 
 *                        and on failure a value from CRYS_RSA_error.h or CRYS_SST_error.h
 */

CEXPORT_C CRYSError_t CRYS_SST_RSA_KG_GenerateKeyPairCRT(DxUint32_t					TeansactionId,
														 SSTSessionId_t				SessionId,
														 SSTHandle_t				MasterAuthHandle,
														 SSTDataType_t				DataType,
														 SSTHandle_t				*KeyHandle_ptr,
														 DxUint8_t					*PubExp_ptr,
														 DxUint16_t					PubExpSizeInBytes,
														 DxUint32_t					KeySize,
														 CRYS_SST_RSA_keys_and_data_container_t	*KeyGenData_ptr)
{

	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_SST_KG_RSA_CRT_OP_CODE, 10,
	   							 /* PARAMETERS: */
								 TeansactionId,
							     SessionId,
								 MasterAuthHandle,
								 DataType,
								 KeyHandle_ptr,
								 PubExp_ptr,
								 PubExpSizeInBytes, KeySize,
								 KeyGenData_ptr);
}

#ifdef __cplusplus
}
#endif

#endif
